' Instances of this class are used to represent sensors that produce
' values that are the average of measurements made over a period of
' time. 
Public Class AveragingSensor
    Inherits SimpleSensor

    ' This constructor is intended to be called by a factory method
    ' object that is in the same package as this class and the the
    ' classes that implement its operations.
    ' impl - The object that implements the sensor type-specific
    '        operations this object will provide.
    Public Sub New(ByVal impl As AveragingSensorImpl)
        MyBase.New(impl)
    End Sub

    ' Averaging sensors produce a value that is the average of
    ' measurements made over a period of time.  That period of time
    ' begins when this method is called.
    Public Sub BeginAverage()
        CType(Impl, AveragingSensorImpl).BeginAverage()
    End Sub
End Class 'AveragingSensor 
